<?php

namespace WPDesk\FCF\Free\Settings\Option;

use WPDesk\FCF\Free\Settings\Tab\AppearanceTab;

/**
 * {@inheritdoc}
 */
class CssOption extends OptionAbstract {

	const FIELD_NAME = 'class';

	/**
	 * {@inheritdoc}
	 */
	public function get_option_name(): string {
		return self::FIELD_NAME;
	}

	/**
	 * {@inheritdoc}
	 */
	public function get_option_tab(): string {
		return AppearanceTab::TAB_NAME;
	}

	/**
	 * {@inheritdoc}
	 */
	public function get_option_type(): string {
		return self::FIELD_TYPE_TEXT;
	}

	/**
	 * {@inheritdoc}
	 */
	public function get_option_label(): string {
		return __( 'CSS class', 'flexible-checkout-fields' );
	}

	/**
	 * {@inheritdoc}
	 */
	public function get_label_tooltip(): string {
		return __( 'Enter CSS classes separated by a space.', 'flexible-checkout-fields' );
	}

	/**
	 * {@inheritdoc}
	 */
	public function get_default_value() {
		return 'form-row-wide';
	}

	/**
	 * {@inheritdoc}
	 */
	public function update_field_data( array $field_data, array $field_settings ): array {
		$option_name = $this->get_option_name();
		$option_value = $field_settings[ $option_name ] ?? $this->get_default_value();

		$option_value = $field_settings[ $option_name ] ?? $this->get_default_value();

		$field_data[ $option_name ] = $this->sanitize_option_value(
			implode( ' ', (array) $option_value )
		);
		return $field_data;
	}
}
